
(function () {
  const ignoredTags = ['html', 'body', 'script', 'style'];
  const recycleBin = document.createElement('div');
  recycleBin.id = 'recycled-elements';

  const recycleBinTitle = document.createElement('div');
  recycleBinTitle.textContent = '被点击的元素将按点击顺序显示在这里';
  recycleBin.appendChild(recycleBinTitle);

  const recycleBinList = document.createElement('div');
  recycleBinList.className = 'recycled-list';
  recycleBin.appendChild(recycleBinList);

  recycleBin.style.cssText = `
    position: relative;
    margin-top: 100px;
    padding: 20px;
    border-top: 2px dashed #aaa;
    background: #f9f9f9;
    font-size: 14px;
    font-family: sans-serif;
  `;

  document.body.appendChild(recycleBin);

  // 添加左右两张图片
  const leftImage = document.createElement('img');
  leftImage.src = chrome.runtime.getURL('image/left.png');
  leftImage.className = 'plugin-left-image';
  document.body.appendChild(leftImage);

  const rightImage = document.createElement('img');
  rightImage.src = chrome.runtime.getURL('image/right.png');
  rightImage.className = 'plugin-right-image';
  document.body.appendChild(rightImage);

  let clickCount = 0;

  document.addEventListener('click', function (e) {
    const target = e.target;
    const tagName = target.tagName.toLowerCase();

    if (ignoredTags.includes(tagName) || target.closest('#recycled-elements')) return;

    e.preventDefault();
    e.stopPropagation();

    clickCount += 1;

    const rect = target.getBoundingClientRect();
    const computedStyle = window.getComputedStyle(target);
    const originalDisplay = computedStyle.display;

    if (rect.width > 0) {
      target.style.width = `${rect.width}px`;
    }
    if (rect.height > 0) {
      target.style.height = `${rect.height}px`;
    }
    if (originalDisplay === 'inline') {
      target.style.display = 'inline-block';
    }

    const wrapper = document.createElement('div');
    wrapper.className = 'recycled-item';

    const label = document.createElement('div');
    label.className = 'recycled-label';
    label.textContent = `#${clickCount}`;
    wrapper.appendChild(label);

    wrapper.appendChild(target);
    recycleBinList.appendChild(wrapper);
  }, true);
})();
